<!-- start Simple Custom CSS and JS -->
<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function() {
    var currentUrl = window.location.href.replace(/\/$/, ""); // remove trailing slash
    var boxes = document.querySelectorAll(".service-style5 a");

    boxes.forEach(function(link){
        var linkUrl = link.href.replace(/\/$/, ""); // remove trailing slash for match
        var box = link.closest(".service-style5");

        // Hover effect for all boxes
        var inner = box.querySelector(".service-content") || box.querySelector(".inner-box") || box;
        inner.addEventListener("mouseenter", function() {
            inner.style.backgroundColor = ""; // light background on hover
            inner.style.transform = "translateY(-6px)";
        });
        inner.addEventListener("mouseleave", function() {
            if(!box.classList.contains("active-page")){
                inner.style.backgroundColor = ""; // reset if not active
                inner.style.transform = "translateY(0)";
            }
        });

        // Check if this link matches current URL
        if(linkUrl === currentUrl){
            box.classList.add("active-page"); // mark as active

            // Active background and transform
            inner.style.backgroundColor = "#9a563a"; // active background
            inner.style.transform = "translateY(-6px)";
            inner.style.boxShadow = "inset 0 0 0 2px #9a563a"; // optional inset border
            inner.style.padding = "2px 2px"; // optional padding
            inner.style.transition = "all 0.4s ease";

           
		
		
            // Text color
            var texts = box.querySelectorAll(".service-text, .service-text h3, .service-text p, .service-title h3");
            texts.forEach(function(el){ el.style.color = "#fff"; el.style.transition = "all 0.4s ease"; });

            // Icons color
            var icons = box.querySelectorAll(".service-style5 .service-icon,.service-icon i, .service-icon svg");
            icons.forEach(function(el){ el.style.color = "#fff"; el.style.fill = "#fff"; });
		}
    });
});
</script>
<!-- end Simple Custom CSS and JS -->
