<?php
/**
 * @Packge     : Wellnez
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Header
get_header();

/**
 * Blog Start Wrapper
 */
do_action( 'wellnez_blog_start_wrap' );

/**
 * Blog Column Start Wrapper
 */
do_action( 'wellnez_blog_col_start_wrap' );
?>

<div class="row search-active">

<?php if ( have_posts() ) : ?>

    <?php while ( have_posts() ) : the_post(); ?>

        <?php
        $column_class = is_active_sidebar( 'wellnez-blog-sidebar' )
            ? 'col-md-6'
            : 'col-md-4';
        ?>

        <div class="<?php echo esc_attr( $column_class ); ?> grid-item">
            <div class="vs-search">

                <?php if ( has_post_thumbnail() ) : ?>
                    <div class="search-grid-img image-scale-hover">
                        <a href="<?php echo esc_url( get_permalink() ); ?>">
                            <?php the_post_thumbnail( 'medium_large' ); ?>
                        </a>
                    </div>
                <?php endif; ?>

                <div class="search-grid-content">

                    <!-- Title -->
                    <h4 class="search-grid-title fw-semibold">
                        <a href="<?php echo esc_url( get_permalink() ); ?>">
                            <?php echo wellnez_highlight_search_term( esc_html( get_the_title() ) ); ?>
                        </a>
                    </h4>

                    <!-- Excerpt -->
                    <div class="search-grid-excerpt">
                        <?php
                        echo wellnez_highlight_search_term(
                            esc_html( wp_trim_words( get_the_excerpt(), 22, '...' ) )
                        );
                        ?>
                    </div>

                    <!-- Read More -->
                    <a class="search-read-more" href="<?php echo esc_url( get_permalink() ); ?>">
                        <?php esc_html_e( 'Leer más', 'wellnez' ); ?>
                    </a>

                </div><!-- /.content -->

            </div><!-- /.vs-search -->
        </div><!-- /.grid-item -->

    <?php endwhile; ?>

    <?php wp_reset_postdata(); ?>

<?php else : ?>

    <div class="col-12">
        <div class="search-no-results-box">

            <h2><?php esc_html_e( 'No se encontraron resultados', 'wellnez' ); ?></h2>

            <p>
                <?php esc_html_e(
                    'Lo sentimos, pero nada coincide con los términos de búsqueda. Inténtalo de nuevo con palabras diferentes.',
                    'wellnez'
                ); ?>
            </p>

            <form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                <input
                    type="search"
                    class="search-field"
                    placeholder="<?php esc_attr_e( 'Buscar aquí…', 'wellnez' ); ?>"
                    value="<?php echo get_search_query(); ?>"
                    name="s"
                />
                <button type="submit" class="search-submit">
                    <?php esc_html_e( 'Buscar', 'wellnez' ); ?>
                </button>
            </form>

        </div>
    </div>

<?php endif; ?>

</div><!-- /.row -->

<?php
/**
 * Blog Pagination
 */
do_action( 'wellnez_blog_pagination' );

/**
 * Blog Column End Wrapper
 */
do_action( 'wellnez_blog_col_end_wrap' );

/**
 * Blog Sidebar
 */
do_action( 'wellnez_blog_sidebar' );

/**
 * Blog End Wrapper
 */
do_action( 'wellnez_blog_end_wrap' );

// Footer
get_footer();
