<?php
/**
 * @Packge     : Wellnez
 * @Version    : 1.0
 * @Author     : Vecurosoft
 * @Author URI : https://www.vecurosoft.com/
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Include File
 *
 */

// Constants
require_once get_parent_theme_file_path() . '/inc/wellnez-constants.php';

//theme setup
require_once WELLNEZ_DIR_PATH_INC . 'theme-setup.php';

//essential scripts
require_once WELLNEZ_DIR_PATH_INC . 'essential-scripts.php';

if( class_exists( 'WooCommerce' ) ){
    // Woo Hooks
    require_once WELLNEZ_DIR_PATH_INC . 'woo-hooks/wellnez-woo-hooks.php';

    // Woo Hooks Functions
    require_once WELLNEZ_DIR_PATH_INC . 'woo-hooks/wellnez-woo-hooks-functions.php';
}


// plugin activation
require_once WELLNEZ_DIR_PATH_FRAM . 'plugins-activation/wellnez-active-plugins.php';

// meta options
require_once WELLNEZ_DIR_PATH_FRAM . 'wellnez-meta/wellnez-config.php';

// page breadcrumbs
require_once WELLNEZ_DIR_PATH_INC . 'wellnez-breadcrumbs.php';

// sidebar register
require_once WELLNEZ_DIR_PATH_INC . 'wellnez-widgets-reg.php';

//essential functions
require_once WELLNEZ_DIR_PATH_INC . 'wellnez-functions.php';

// theme dynamic css
require_once WELLNEZ_DIR_PATH_INC . 'wellnez-commoncss.php';

// helper function
require_once WELLNEZ_DIR_PATH_INC . 'wp-html-helper.php';

// Demo Data
require_once WELLNEZ_DEMO_DIR_PATH . 'demo-import.php';

// pagination
require_once WELLNEZ_DIR_PATH_INC . 'wp_bootstrap_pagination.php';

// wellnez options
require_once WELLNEZ_DIR_PATH_FRAM . 'wellnez-options/wellnez-options.php';

// hooks
require_once WELLNEZ_DIR_PATH_HOOKS . 'hooks.php';

// hooks funtion
require_once WELLNEZ_DIR_PATH_HOOKS . 'hooks-functions.php';

/**
 * FULL Spanish translation for Search (Wellnez / WordPress / Elementor)
 */
add_filter( 'gettext', 'wellnez_full_search_translation', 20, 3 );
function wellnez_full_search_translation( $translated, $text, $domain ) {

    // Apply globally or only on search pages
    if ( is_search() || is_admin() === false ) {

        $translations = array(

            // Search labels
            'Search'                                => 'Buscar',
            'Search…'                               => 'Buscar…',
			'Search here…'                          => 'Buscar…',
            'Search here'                           => 'Buscar aquí',
            'Search for:'                           => 'Buscar:',
            'Search Results'                        => 'Resultados de búsqueda',
            'Search results for:'                   => 'Resultados de búsqueda para:',
            'Results for:'                          => 'Resultados para:',

            // No results messages
            'Nothing Found'                         => 'No se encontraron resultados',
            'No results found'                      => 'No se encontraron resultados',
            'No Results Found'                      => 'No se encontraron resultados',

            'Sorry, but nothing matched your search terms. Please try again with some different keywords.' 
            => 'Lo sentimos, pero no hay resultados que coincidan con tu búsqueda. Por favor, inténtalo de nuevo con otras palabras clave.',

            'It seems we can’t find what you’re looking for.' 
            => 'Parece que no podemos encontrar lo que estás buscando.',

            'Try a different search'                => 'Intenta con otra búsqueda',
            'Please try again with different keywords.' 
            => 'Por favor, inténtalo de nuevo con otras palabras clave.',

            // Buttons / links
            'Read More'                             => 'Leer más',
            'View More'                             => 'Ver más',
            'Continue Reading'                     => 'Seguir leyendo',

            // Placeholders
            'Type and hit enter'                    => 'Escribe y presiona Enter',
            'Type and press enter'                  => 'Escribe y presiona Enter',
            'Enter keyword'                         => 'Introduce una palabra clave',

            // Elementor / widgets
            'Search widget'                         => 'Buscador',
            'Search Form'                           => 'Formulario de búsqueda',
        );

        if ( isset( $translations[ $text ] ) ) {
            return $translations[ $text ];
        }
    }

    return $translated;
}
/**
 * Highlight search term
 */
function wellnez_highlight_search_term( $text ) {
    if ( is_search() && get_search_query() ) {
        $keys = explode( ' ', get_search_query() );
        $text = preg_replace(
            '/(' . implode( '|', array_map( 'preg_quote', $keys ) ) . ')/iu',
            '<span class="search-highlight">$1</span>',
            $text
        );
    }
    return $text;
}

